import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import '../../app_assets.dart';
import 'animation_button_effect.dart';

class InvoiceDownload extends StatelessWidget {
  final Widget? child;

  const InvoiceDownload({super.key, required this.child});

  @override
  Widget build(BuildContext context) {
    return ButtonEffectAnimation(
      child: GestureDetector(
        onTap: () {
          showDialog(
              context: context,
              builder: (context) {
                return LayoutBuilder(builder: (context, constraints) {
                  return SimpleDialog(
                    titlePadding:
                        EdgeInsets.symmetric(horizontal: 24, vertical: 16),
                    title: Container(
                      decoration: BoxDecoration(
                        color: Style.white,
                      ),
                      constraints: BoxConstraints(
                        maxHeight: constraints.maxHeight * 0.8,
                        maxWidth: 300,
                      ),
                      child: child,
                    ),
                  );
                });
              });
        },
        child: Container(
          padding: const EdgeInsets.symmetric(vertical: 10, horizontal: 18),
          decoration: BoxDecoration(
            color: Style.invoiceColor,
            borderRadius: BorderRadius.circular(12),
          ),
          child: Row(
            children: [
              SvgPicture.asset(
                Assets.svgFilePdf,
                height: 18,
                width: 18,
                colorFilter: const ColorFilter.mode(
                  Style.white,
                  BlendMode.srcIn,
                ),
              ),
              8.horizontalSpace,
              Text(
                AppHelpers.getTranslation(TrKeys.invoiceDownload),
                style: Style.interNormal(
                  size: 14,
                  letterSpacing: 0,
                  color: Style.white,
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
